
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was VorbisConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################
set(Vorbis_VERSION "1.3.5")
set_and_check(Vorbis_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include")
if(NOT TARGET libvorbis OR NOT TARGET libvorbis_static OR NOT TARGET libvorbisfile_static OR NOT TARGET libvorbisfile)
    include("${CMAKE_CURRENT_LIST_DIR}/Vorbis.cmake")
endif()
set(Vorbis_STATIC_LIBRARY libvorbis_static)
set(Vorbis_SHARED_LIBRARY libvorbis)
set(Vorbisfile_STATIC_LIBRARY libvorbisfile_static)
set(Vorbisfile_SHARED_LIBRARY libvorbisfile)
set(Vorbis_LIBRARIES ${Vorbis_SHARED_LIBRARY} ${Vorbisfile_SHARED_LIBRARY})
